//AIM:Compute the resulting output voltage of a photodetector
//Software version Scilab 5.5.2
//OS Windows 7
clc;
clear;
//Let quantum efficiency=0.9,wavelength=1.3 micrometre & incident power level 
//of -37dBm
//Also we consider load resistance is 50 ohms and 1000 ohms.
n=0.9;//n=Quantum efficiency
lambda=1.3*(10^(-6));//lambda=wavelength
//Incident optical power Pia=-37dBm
Pia=-37;//Pia=Incident power level
Pi=(10^(-3))*(10^(Pia/10));//Computing the incident optical power in Watts
disp('Watts',Pi,'Incident optical power (Pi) in Watts=')
h=(6.625)*(10^(-34));//h=Planck's constant
c=(3)*(10^(8));//c=Speed of light
e=(1.6)*(10^(-19));//Electron
I=(n*e*lambda*Pi)/(h*c);//Computing current I
disp('Amp',I,'Current(I)=')
//Voltage across resistor of 50 ohms
R1=50;
V1=I*R1;//Basic relation:Voltage=Current*Resistance
disp('Volts',V1,'V1=')

//Voltage across resistor of  ohms
R2=1000;
V2=I*R2;//Basic relation:Voltage=Current*Resistance
disp('Volts',V2,'V2=')

